from ctypes import *
import os
import numpy as np

'''******************************** Loading the HSDCPro Automation DLL ****************************************************'''

if('PROGRAMFILES(X86)' in os.environ): #selecting the DLL path from HSDC Pro installed location based on 32 bit or 64 bit OS
    dll_path = "C:\\Program Files (x86)\\Texas Instruments\\High Speed Data Converter Pro\\HSDCPro Automation DLL\\32Bit DLL\\HSDCProAutomation.dll"
else:
    dll_path = "C:\\Program Files\\Texas Instruments\\High Speed Data Converter Pro\\HSDCPro Automation DLL\\32Bit DLL\\HSDCProAutomation.dll"
HSDC_Pro = cdll.LoadLibrary(dll_path)

TimeoutinMs = 30000

'''*************************************************************************************************************************'''
'''**************************** The actual call to the function contained in the dll ***************************************'''
'''*************************************************************************************************************************'''

f0 = c_double(0)
df = c_double(0)
FFTArrayLength = c_int(16385)
ArrayType = (c_double * 16385)()
print ("Getting FFT Data...")
Err_Status = HSDC_Pro.Get_FFT_Data(TimeoutinMs,byref(f0),byref(df),ArrayType,byref(FFTArrayLength))
print ("Error Status = " + str(Err_Status))

print("f0 : "+str(f0))
print("df : "+str(df))
print("FFTLen : "+str(FFTArrayLength))
print(list(ArrayType))

np.frombuffer(ArrayType, dtype = np.double)

print (str(ArrayType[0]))
print (str(ArrayType[1]))
